	function PLOT_FD_RESPONSE2(wT, H, phasedelay, Ncases, d, D)
	
	%	Plots the magnitude and phase delay response for a 
	%	fractional-delay filter. 
	%
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2016-05-04
	% 	Modified by: 	 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	
	%	warning off
	subplot(2,1,1)
	for k = 1:Ncases
		plot(wT, abs(H(k,:)),'linewidth', 2); hold on
		if k<= 6
			text(2.8,0.2-1.3*d(k),['|d | = ',num2str(-d(k))]);   % May need to be changed
		end
		hold on
	end
	axis([0, pi, 0, 1.1 ]);	grid on
	set(gca,'FontName', 'times','FontSize', 14);
	Ylabel = 'H';
	ylabel(['{|\it' Ylabel '}({\ite^j^\omega^T})|'],'FontName', fn,'FontSize',fs);
	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};
	xlabel('{\it\omegaT} [rad]');	
	xtick(ax,lab);
	hold off
	
	subplot(2,1,2)
 	for k = 1:Ncases
		plot(wT, phasedelay(k,:),'linewidth', 2); hold on
		text(0.15,d(k)+7.55,['d = ',num2str(d(k))]); % May need to be changed
		hold on
	end
 	axis([0 pi 6.9 8.1]); grid on
	set(gca,'FontName', 'times','FontSize', 14);
	ylabel(['{\it\tau_f}({\ite^j^\omega^T})   [T]'],'FontName', fn,'FontSize',fs);
	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};
	xlabel('{\it\omegaT} [rad]');	
	xtick(ax,lab);
	hold off
	warning on	
	
	
